// ==UserScript==
// @name         あいもげ 広い画レス
// @namespace    http://tampermonkey.net/
// @version      0.3
// @description  広くするよ
// @match        https://nijiurachan.net/pc/thread.php*
// @grant        none
// ==/UserScript==

(function() {
    //画像用
    const imgHaba = (img) => {
        img.addEventListener("load", () => {
            img.closest("[data-thread-op], .rtd").querySelector("blockquote")?.style.setProperty("margin-left", `${20 + img.width + 20}px`, "important");
        }, {once: true});

        img.src = img.src;
    };
    //動画用
    const videoHaba = (video) => {
        video.addEventListener("loadedmetadata", () => {
            const videoWidth = Math.ceil(parseFloat(window.getComputedStyle(video).width));
            video.closest("[data-thread-op], .rtd").querySelector("blockquote")?.style.setProperty("margin-left", `${20 + videoWidth + 20}px`, "important");
        }, {once: true});

        video.addEventListener("play", () => {
            let videoWidth;
            if(video.videoHeight >= 300) videoWidth = Math.ceil(video.videoWidth * (300 / video.videoHeight));
            else videoWidth = video.videoWidth;
            if(videoWidth >= 400) videoWidth = 400;
            video.closest("[data-thread-op], .rtd").querySelector("blockquote")?.style.setProperty("margin-left", `${20 + videoWidth + 20}px`, "important");
        }, {once: true});

        video.src = video.src;
    };

    //監視用
    const observer = new MutationObserver((mutations) => {
        for(const mutation of mutations) {
            for(const node of mutation.addedNodes) {
                //追加･削除されたのは要素か
                if(node.nodeType === 1) {
                    //画像レス
                    if(node.querySelector("a > img")) {
                        for(const img of node.querySelectorAll("a > img")) {
                            imgHaba(img);
                        }
                    }
                    //あいもげホバー表示ちゃん用画像レス
                    if(node.querySelector("a > .media_wrapper > img")) {
                        for(const img of node.querySelectorAll("a > .media_wrapper > img")) {
                            imgHaba(img);
                        }
                    }
                    //動画レス
                    if(node.querySelector("video > a")) {
                        for(const video of node.querySelectorAll("video")) {
                            videoHaba(video);
                        }
                    }
                }
            }
        }
    });

    //スレ画が読込まれたら動く
    let checkCount = 0;
    const loadedCheck = setInterval(() => {
        checkCount ++;
        if(document.querySelector(".thre a > img, .thre video > a, .thre .media_wrapper")) {
            setTimeout(() => {
                //監視前に一旦やっとく
                //画像レス
                for(const img of document.querySelectorAll(".thre a > img")) {
                    imgHaba(img);
                }
                //あいもげホバー表示ちゃん用画像レス
                for(const img of document.querySelectorAll(".thre a > .media_wrapper > img")) {
                    imgHaba(img);
                }
                //動画レス
                for(const video of document.querySelectorAll(".thre video")) {
                    videoHaba(video);
                }
                //追加されるレスを監視
                observer.observe(document.querySelector(".thre"), {childList: true, subtree: true});
            }, 1000);
            clearInterval(loadedCheck);
        }
        if(checkCount > 14) {
            clearInterval(loadedCheck);
        }
    }, 1000);
})();

/* 更新ログ
作り始め
動画再生時の幅計算を修正
スレ読込み時に広がってないのを修正
*/